function layout()
return {

modifiers = {
['LShift'] = 'LShift',
['RShift'] = 'RShift',
['LAlt'] = 'LAlt',
['RAlt'] = 'RAlt',
['LCtrl'] = 'LCtrl',
['RCtrl'] = 'RCtrl',
['LWin'] = 'LWin',
['RWin'] = 'RWin',
},

keyCommands = {

-- Temporary
{combos = {{key = 'X', reformers = {'LShift', 'LCtrl'}}}, down = iCommandViewExplosion, name = 'Explosion', category = 'Cheat'},

-- Gameplay
{combos = {{key = '`'}}, down = ICommandToggleConsole, name = 'Toggle Console', category = 'Debug'},
{combos = {{key = 'Pause', reformers = {'LShift', 'LWin'}}}, down = iCommandActivePauseOnOff, name = 'Active Pause', category = 'Cheat'},
{combos = {{key = 'Esc'}}, 									down = iCommandQuit, name = 'End mission', category = 'General'},
{combos = {{key = 'B', reformers = {'LAlt'}}},				down = iCommandViewBriefing, name = 'View briefing on/off', category = 'General'},

{combos = {{key = 'Pause'}}, 								down = iCommandBrakeGo, name = 'Pause', category = 'General'},
{combos = {{key = 'Z', reformers = {'LCtrl'}}}, 			down = iCommandAccelerate, name = 'Time accelerate', category = 'General'},
{combos = {{key = 'Z', reformers = {'LAlt'}}}, 				down = iCommandDecelerate, name = 'Time decelerate', category = 'General'},
{combos = {{key = 'Z', reformers = {'LShift'}}}, 			down = iCommandNoAcceleration, name = 'Time normal', category = 'General'},
{combos = {{key = '\''}}, 									down = iCommandScoresWindowToggle, name = 'Score window', category = 'General'},
{combos = {{key = '\'', reformers = {'RShift'}}}, 			down = iCommandDebriefing, name = 'Show debriefing window', category = 'General'},
{combos = {{key = 'Tab'}}, 									down = iCommandChat, name = 'Multiplayer chat - mode All', category = 'General'},
{combos = {{key = 'Tab', reformers = {'RCtrl'}}}, 			down = iCommandFriendlyChat, name = 'Multiplayer chat - mode Allies', category = 'General'},
{combos = {{key = 'Y', reformers = {'LCtrl'}}}, 			down = iCommandInfoOnOff, name = 'Info bar view toggle', category = 'General'},
{combos = {{key = 'Tab', reformers = {'RCtrl', 'RShift'}}}, down = iCommandRecoverHuman, name = 'Get new plane - respawn', category = 'General'},
{combos = {{key = 'SysRQ'}}, 								down = iCommandScreenShot, name = 'Screenshot', category = 'General'},
{combos = {{key = 'Tab', reformers = {'LShift'}}}, 			down = iCommandTrkEsc, name = 'Playback track cancel', category = 'General'},
{combos = {{key = 'Y', reformers = {'LShift'}}}, 			down = iCommandInfoOnOff, name = 'Info bar view toggle', category = 'General'},
{combos = {{key = 'Pause', reformers = {'RShift'}}},		down = iCommandOneFrame, name = 'One frame mode', category = 'General'},
{combos = {{key = 'Pause', reformers = {'RCtrl'}}}, 		down = iCommandGraphicsFrameRate, name = 'Frame rate counter - Service info', category = 'General'},
{combos = {{key = 'Y', reformers = {'LAlt'}}}, 				down = iCommandViewCoordinatesInLinearUnits, name = 'Coordinates units change', category = 'General'},
{combos = {{key = 'M', reformers = {'RCtrl'}}}, 			down = iCommandChat, name = 'Multiplayer chat - mode All', category = 'General'},
{combos = {{key = 'M', reformers = {'RAlt'}}}, 				down = iCommandFriendlyChat, name = 'Multiplayer chat - mode Allies', category = 'General'},
{combos = {{key = 'C', reformers = {'LAlt'}}}, 				down = iCommandCockpitClickModeOnOff, name = 'Clickable mouse cockpit mode On/Off', category = 'General'},
{combos = {{key = 'Enter', reformers = {'RCtrl'}}}, 		down = iCommandPlane_ShowControls, name = 'Show controls indicator' , category = 'General'},

-- Sensors
--{combos = {{key = 'R', reformers = {'RShift'}}}, down = iCommandChangeRWRMode, name = 'Change RWR/SPO Mode', category = 'Sensors'},
--{combos = {{key = ',', reformers = {'RAlt'}}}  , down = iCommandPlaneThreatWarnSoundVolumeDown, name = 'RWR/SPO Sound Signals Volume Down', category = 'Sensors'},
--{combos = {{key = '.', reformers = {'RAlt'}}}  , down = iCommandPlaneThreatWarnSoundVolumeUp, name = 'RWR/SPO Sound Signals Volume Up', category = 'Sensors'},

-- Communications
{combos = {{key = 'E', reformers = {'LWin'}}}, 	down = iCommandPlaneDoAndHome, name = 'Dispatch wingmans - complete mission and RTB', category = 'Communications'},
{combos = {{key = 'R', reformers = {'LWin'}}}, 	down = iCommandPlaneDoAndBack, name = 'Dispatch wingmans - complete mission and rejoin', category = 'Communications'},
{combos = {{key = 'T', reformers = {'LWin'}}}, 	down = iCommandPlaneFormation, name = 'Toggle formation', category = 'Communications'},
{combos = {{key = 'Y', reformers = {'LWin'}}}, 	down = iCommandPlaneJoinUp, name = 'Join up formation', category = 'Communications'},
{combos = {{key = 'Q', reformers = {'LWin'}}}, 	down = iCommandPlaneAttackMyTarget, name = 'Attack my target', category = 'Communications'},
{combos = {{key = 'W', reformers = {'LWin'}}}, 	down = iCommandPlaneCoverMySix, name = 'Cover me', category = 'Communications'},
{combos = {{key = 'U', reformers = {'LWin'}}}, 	down = iCommandAWACSHomeBearing, name = 'Ask AWACS home airbase', category = 'Communications'},
{combos = {{key = 'I', reformers = {'LWin'}}}, 	down = iCommandAWACSTankerBearing, name = 'Ask AWACS available tanker', category = 'Communications'},
{combos = {{key = 'G', reformers = {'LWin'}}}, 	down = iCommandPlane_EngageGroundTargets, name = 'Attack Ground Targets', category = 'Communications'},
{combos = {{key = 'D', reformers = {'LWin'}}}, 	down = iCommandPlane_EngageAirDefenses, name = 'Attack Air Defenses', category = 'Communications'},
{combos = {{key = '\\'}}, 						down = iCommandToggleCommandMenu, name = 'Communication menu', category = 'Communications'},
{combos = {{key = '\\', reformers = {'LShift'}}}, down = ICommandSwitchDialog, name = 'Switch dialog', category = 'Communications'},

-- View                                                    
{combos = {{key = 'Num4'}}, pressed = iCommandViewLeftSlow, up = iCommandViewStopSlow, name = 'View Left slow', category = 'View'},
{combos = {{key = 'Num6'}}, pressed = iCommandViewRightSlow, up = iCommandViewStopSlow, name = 'View Right slow', category = 'View'},
{combos = {{key = 'Num8'}}, pressed = iCommandViewUpSlow, up = iCommandViewStopSlow, name = 'View Up slow', category = 'View'},
{combos = {{key = 'Num2'}}, pressed = iCommandViewDownSlow, up = iCommandViewStopSlow, name = 'View Down slow', category = 'View'},
{combos = {{key = 'Num9'}}, pressed = iCommandViewUpRightSlow, up = iCommandViewStopSlow, name = 'View Up Right slow', category = 'View'},
{combos = {{key = 'Num3'}}, pressed = iCommandViewDownRightSlow, up = iCommandViewStopSlow, name = 'View Down Right slow', category = 'View'},
{combos = {{key = 'Num1'}}, pressed = iCommandViewDownLeftSlow, up = iCommandViewStopSlow, name = 'View Down Left slow', category = 'View'},
{combos = {{key = 'Num7'}}, pressed = iCommandViewUpLeftSlow, up = iCommandViewStopSlow, name = 'View Up Left slow', category = 'View'},
{combos = {{key = 'Num5'}}, pressed = iCommandViewCenter, name = 'View Center', category = 'View'},

{combos = {{key = 'Num*'}}, 							pressed = iCommandViewForwardSlow, up = iCommandViewForwardSlowStop, name = 'Zoom in slow', category = 'View'},
{combos = {{key = 'Num/'}}, 							pressed = iCommandViewBackSlow, up = iCommandViewBackSlowStop, name = 'Zoom out slow', category = 'View'},
{combos = {{key = 'NumEnter'}}, 						down = iCommandViewAngleDefault, name = 'Zoom normal', category = 'View'},
{combos = {{key = 'Num*', reformers = {'RCtrl'}}}, 		pressed = iCommandViewExternalZoomIn, up = iCommandViewExternalZoomInStop, name = 'Zoom external in', category = 'View'},
{combos = {{key = 'Num/', reformers = {'RCtrl'}}}, 		pressed = iCommandViewExternalZoomOut, up = iCommandViewExternalZoomOutStop, name = 'Zoom external out', category = 'View'},
{combos = {{key = 'NumEnter', reformers = {'RCtrl'}}}, 	down = iCommandViewExternalZoomDefault, name = 'Zoom external normal', category = 'View'},
{combos = {{key = 'Num*', reformers = {'LAlt'}}}, 		down = iCommandViewSpeedUp, name = 'F11 camera moving forward', category = 'View'},
{combos = {{key = 'Num/', reformers = {'LAlt'}}}, 		down = iCommandViewSlowDown, name = 'F11 camera moving backward', category = 'View'},


{combos = {{key = 'F1'}}, 							down = iCommandViewCockpit, name = 'F1 Cockpit view', category = 'View'},
{combos = {{key = 'F1', reformers = {'LCtrl'}}}, 	down = iCommandNaturalViewCockpitIn, name = 'F1 Natural head movement view', category = 'View'},
{combos = {{key = 'F1', reformers = {'LAlt'}}}, 	down = iCommandViewHUDOnlyOnOff, name = 'F1 HUD only view switch', category = 'View'},
{combos = {{key = 'F2'}}, 							down = iCommandViewAir, name = 'F2 Aircraft view', category = 'View'},
{combos = {{key = 'F2', reformers = {'LCtrl'}}}, 	down = iCommandViewMe, name = 'F2 View own aircraft', category = 'View'},
{combos = {{key = 'F2', reformers = {'RAlt'}}}, 	down = iCommandViewFromTo, name = 'F2 Toggle camera position', category = 'View'},
{combos = {{key = 'F2', reformers = {'LAlt'}}}, 	down = iCommandViewLocal, name = 'F2 Toggle local camera control', category = 'View'},
{combos = {{key = 'F3'}}, 							down = iCommandViewTower, name = 'F3 Fly-By view', category = 'View'},
{combos = {{key = 'F3', reformers = {'LCtrl'}}}, 	down = iCommandViewTowerJump, name = 'F3 Fly-By jump view', category = 'View'},
{combos = {{key = 'F4'}}, 							down = iCommandViewChaseArcade, name = 'F4 Arcade View', category = 'View'},
{combos = {{key = 'F4', reformers = {'LShift'}}}, 	down = iCommandViewRear, name = 'F4 Look back view', category = 'View'},
{combos = {{key = 'F4', reformers = {'LCtrl'}}}, 	down = iCommandViewChase, name = 'F4 Chase view', category = 'View'},
{combos = {{key = 'F5'}}, 							down = iCommandViewFight, name = 'F5 nearest AC view', category = 'View'},
{combos = {{key = 'F5', reformers = {'LCtrl'}}}, 	down = iCommandViewFightGround, name = 'F5 Ground hostile view', category = 'View'},
{combos = {{key = 'F6'}}, 							down = iCommandViewWeapons, name = 'F6 Released weapon view', category = 'View'},
{combos = {{key = 'F6', reformers = {'LCtrl'}}}, 	down = iCommandViewWeaponAndTarget, name = 'F6 Weapon to target view', category = 'View'},
{combos = {{key = 'F7'}}, 							down = iCommandViewGround, name = 'F7 Ground unit view', category = 'View'},
{combos = {{key = 'F7', reformers = {'LCtrl'}}},    down = iCommandViewJFO, name = 'F7 Ground JFO/JTAC view', category = 'View'},
{combos = {{key = 'F9'}}, 							down = iCommandViewNavy, name = 'F9 Ship view', category = 'View'},
{combos = {{key = 'F9', reformers = {'LAlt'}}}, 	down = iCommandViewLndgOfficer, name = 'F9 Landing signal officer view', category = 'View'},
{combos = {{key = 'F10'}}, 							down = iCommandViewAWACS, name = 'F10 Theater map view', category = 'View'},
{combos = {{key = 'F10', reformers = {'LCtrl'}}}, 	down = iCommandViewAWACSJump, name = 'F10 Jump to theater map view over current point', category = 'View'},
{combos = {{key = 'F11'}}, 							down = iCommandViewFree, name = 'F11 Airport free camera', category = 'View'},
{combos = {{key = 'F11', reformers = {'LCtrl'}}}, 	down = iCommandViewFreeJump, name = 'F11 Jump to free camera', category = 'View'},
{combos = {{key = 'F12'}}, 							down = iCommandViewStatic, name = 'F12 Static object view', category = 'View'},
{combos = {{key = 'F12', reformers = {'LCtrl'}}}, 	down = iCommandViewMirage, name = 'F12 Civil traffic view', category = 'View'},
{combos = {{key = 'F12', reformers = {'LShift'}}}, 	down = iCommandViewLocomotivesToggle, name = 'F12 Trains/cars toggle', category = 'View'},
{combos = {{key = 'F1', reformers = {'LWin'}}} , 	down = iCommandViewPitHeadOnOff, name = 'F1 Head shift movement on / off', category = 'View'},

{combos = {{key = ']', reformers = {'LShift'}}}, 	down = iCommandViewFastKeyboard, name = 'Fast keyboard turn speed', category = 'View'},
{combos = {{key = ']', reformers = {'LCtrl'}}}, 	down = iCommandViewSlowKeyboard, name = 'Slow keyboard turn speed', category = 'View'},
{combos = {{key = ']', reformers = {'LAlt'}}}, 		down = iCommandViewNormalKeyboard, name = 'Normal keyboard turn speed', category = 'View'},
{combos = {{key = '[', reformers = {'LShift'}}}, 	down =  iCommandViewFastMouse, name = 'Fast mouse turn speed', category = 'View'},
{combos = {{key = '[', reformers = {'LCtrl'}}}, 	down = iCommandViewSlowMouse, name = 'Slow mouse turn speed', category = 'View'},
{combos = {{key = '[', reformers = {'LAlt'}}}, 		down = iCommandViewNormalMouse, name = 'Normal mouse turn speed', category = 'View'},


-- Cockpit view
{combos = {{key = 'Num0'}}, 						down = iCommandViewTempCockpitOn, up = iCommandViewTempCockpitOff, name = 'Cockpit panel view in', category = 'View Cockpit'},
{combos = {{key = 'Num0', reformers = {'RCtrl'}}}, 	down = iCommandViewTempCockpitToggle, name = 'Cockpit panel view toggle', category = 'View Cockpit'},
{combos = {{key = 'Num0', reformers = {'RAlt'}}}, 	down = iCommandViewSaveAngles, name = 'Save Cockpit Angles', category = 'View Cockpit'}, -- Save current cockpit camera angles for fast numpad jumps  
{combos = {{key = 'Num8', reformers = {'RShift'}}}, pressed = iCommandViewUp, up = iCommandViewStop, name = 'View up', category = 'View Cockpit'},
{combos = {{key = 'Num2', reformers = {'RShift'}}}, pressed = iCommandViewDown, up = iCommandViewStop, name = 'View down', category = 'View Cockpit'},
{combos = {{key = 'Num4', reformers = {'RShift'}}}, pressed = iCommandViewLeft, up = iCommandViewStop, name = 'View left', category = 'View Cockpit'},
{combos = {{key = 'Num6', reformers = {'RShift'}}}, pressed = iCommandViewRight, up = iCommandViewStop, name = 'View right', category = 'View Cockpit'},
{combos = {{key = 'Num9', reformers = {'RShift'}}}, pressed = iCommandViewUpRight, up = iCommandViewStop, name = 'View up right', category = 'View Cockpit'},
{combos = {{key = 'Num3', reformers = {'RShift'}}}, pressed = iCommandViewDownRight, up = iCommandViewStop, name = 'View down right', category = 'View Cockpit'},
{combos = {{key = 'Num1', reformers = {'RShift'}}}, pressed = iCommandViewDownLeft, up = iCommandViewStop, name = 'View down left', category = 'View Cockpit'},
{combos = {{key = 'Num7', reformers = {'RShift'}}}, pressed = iCommandViewUpLeft, up = iCommandViewStop, name = 'View up left', category = 'View Cockpit'},

{combos = {{key = 'Num8', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraUp, up = iCommandViewCameraCenter, name = 'Camera view up', category = 'View Cockpit'},
{combos = {{key = 'Num2', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraDown, up = iCommandViewCameraCenter, name = 'Camera view down', category = 'View Cockpit'},
{combos = {{key = 'Num4', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraLeft, up = iCommandViewCameraCenter, name = 'Camera view left', category = 'View Cockpit'},
{combos = {{key = 'Num6', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraRight, up = iCommandViewCameraCenter, name = 'Camera view right', category = 'View Cockpit'},
{combos = {{key = 'Num7', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraUpLeft, up = iCommandViewCameraCenter, name = 'Camera view up-left', category = 'View Cockpit'},
{combos = {{key = 'Num1', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraDownLeft, up = iCommandViewCameraCenter, name = 'Camera view down-left', category = 'View Cockpit'},
{combos = {{key = 'Num9', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraUpRight, up = iCommandViewCameraCenter, name = 'Camera view up-right', category = 'View Cockpit'},
{combos = {{key = 'Num3', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraDownRight, up = iCommandViewCameraCenter, name = 'Camera view down-right', category = 'View Cockpit'},

{combos = {{key = 'Num8', reformers = {'RAlt'}}}, 	down = iCommandViewCameraUpSlow, name = 'Camera view up slow', category = 'View Cockpit'},
{combos = {{key = 'Num2', reformers = {'RAlt'}}}, 	down = iCommandViewCameraDownSlow, name = 'Camera view down slow', category = 'View Cockpit'},
{combos = {{key = 'Num4', reformers = {'RAlt'}}}, 	down = iCommandViewCameraLeftSlow, name = 'Camera view left slow', category = 'View Cockpit'},
{combos = {{key = 'Num6', reformers = {'RAlt'}}}, 	down = iCommandViewCameraRightSlow, name = 'Camera view right slow', category = 'View Cockpit'},
{combos = {{key = 'Num7', reformers = {'RAlt'}}}, 	down = iCommandViewCameraUpLeftSlow, name = 'Camera view up-left slow', category = 'View Cockpit'},
{combos = {{key = 'Num1', reformers = {'RAlt'}}}, 	down = iCommandViewCameraDownLeftSlow, name = 'Camera view down-left slow', category = 'View Cockpit'},
{combos = {{key = 'Num9', reformers = {'RAlt'}}}, 	down = iCommandViewCameraDownRight, name = 'Camera view up-right slow', category = 'View Cockpit'},
{combos = {{key = 'Num3', reformers = {'RAlt'}}}, 	down = iCommandViewCameraUpRightSlow, name = 'Camera view down-right slow', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'RShift'}}}, down = iCommandViewCameraCenter, name = 'Center camera view', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'RCtrl'}}}, 	down = iCommandViewCameraReturn, name = 'Return camera', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'RAlt'}}}, 	down = iCommandViewCameraBaseReturn, name = 'Return camera base', category = 'View Cockpit'},

{combos = {{key = 'Num0', reformers = {'LWin'}}}, down = iCommandViewSnapView0,	up = iCommandViewSnapViewStop, name = 'Snap View 0', category = 'View Cockpit'},
{combos = {{key = 'Num1', reformers = {'LWin'}}}, down = iCommandViewSnapView1,	up = iCommandViewSnapViewStop, name = 'Snap View 1', category = 'View Cockpit'},
{combos = {{key = 'Num2', reformers = {'LWin'}}}, down = iCommandViewSnapView2,	up = iCommandViewSnapViewStop, name = 'Snap View 2', category = 'View Cockpit'},
{combos = {{key = 'Num3', reformers = {'LWin'}}}, down = iCommandViewSnapView3,	up = iCommandViewSnapViewStop, name = 'Snap View 3', category = 'View Cockpit'},
{combos = {{key = 'Num4', reformers = {'LWin'}}}, down = iCommandViewSnapView4,	up = iCommandViewSnapViewStop, name = 'Snap View 4', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'LWin'}}}, down = iCommandViewSnapView5,	up = iCommandViewSnapViewStop, name = 'Snap View 5', category = 'View Cockpit'},
{combos = {{key = 'Num6', reformers = {'LWin'}}}, down = iCommandViewSnapView6,	up = iCommandViewSnapViewStop, name = 'Snap View 6', category = 'View Cockpit'},
{combos = {{key = 'Num7', reformers = {'LWin'}}}, down = iCommandViewSnapView7,	up = iCommandViewSnapViewStop, name = 'Snap View 7', category = 'View Cockpit'},
{combos = {{key = 'Num8', reformers = {'LWin'}}}, down = iCommandViewSnapView8,	up = iCommandViewSnapViewStop, name = 'Snap View 8', category = 'View Cockpit'},
{combos = {{key = 'Num9', reformers = {'LWin'}}}, down = iCommandViewSnapView9,	up = iCommandViewSnapViewStop, name = 'Snap View 9', category = 'View Cockpit'},

{combos = {{key = 'N', reformers = {'RWin'}}}, down = iCommandViewLeftMirrorOn ,	up = iCommandViewLeftMirrorOff , name = 'Left Mirror On', category = 'View Cockpit'},
{combos = {{key = 'M', reformers = {'RWin'}}}, down = iCommandViewRightMirrorOn,	up = iCommandViewRightMirrorOff, name = 'Right Mirror On', category = 'View Cockpit'},

{combos = {{key = 'Num*', reformers = {'RShift'}}}, pressed = iCommandViewForward, up = iCommandViewForwardStop, name = 'Zoom in', category = 'View Cockpit'},
{combos = {{key = 'Num/', reformers = {'RShift'}}}, pressed = iCommandViewBack, up = iCommandViewBackStop, name = 'Zoom out', category = 'View Cockpit'},

-- Cockpit Camera Motion (   )
{combos = {{key = 'Num8', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveUp, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Up', category = 'View Cockpit'},
{combos = {{key = 'Num2', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveDown, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Down', category = 'View Cockpit'},
{combos = {{key = 'Num4', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveLeft, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Left', category = 'View Cockpit'},
{combos = {{key = 'Num6', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveRight, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Right', category = 'View Cockpit'},
{combos = {{key = 'Num*', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveForward, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Forward', category = 'View Cockpit'},
{combos = {{key = 'Num/', reformers = {'RCtrl','RShift'}}}, pressed = iCommandViewPitCameraMoveBack, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Back', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'RCtrl','RShift'}}}, down = iCommandViewPitCameraMoveCenter, name = 'Cockpit Camera Move Center', category = 'View Cockpit'},

-- Extended view
{combos = {{key = 'J', reformers = {'LShift'}}}, 			down = iCommandViewCameraJiggle, name = 'Camera jiggle toggle', category = 'View Extended'},
{combos = {{key = 'K', reformers = {'LAlt'}}}, 				down = iCommandViewKeepTerrain, name = 'Keep terrain camera altitude', category = 'View Extended'},
{combos = {{key = 'Home', reformers = {'RCtrl','RShift'}}}, down = iCommandViewFriends, name = 'View friends mode', category = 'View Extended'},
{combos = {{key = 'End', reformers = {'RCtrl' ,'RShift'}}}, down = iCommandViewEnemies, name = 'View enemies mode', category = 'View Extended'},
{combos = {{key = 'Delete', reformers = {'RCtrl'}}}, 		down = iCommandViewAll, name = 'View all mode', category = 'View Extended'},
{combos = {{key = 'Num+', reformers = {'RShift'}}}, 		down = iCommandViewPlus, name = 'Toggle tracking fire weapon', category = 'View Extended'},
{combos = {{key = 'PageDown', reformers = {'LCtrl'}}}, 		down = iCommandViewSwitchForward, name = 'Objects switching direction forward ', category = 'View Extended'},
{combos = {{key = 'PageUp', reformers = {'LCtrl'}}}, 		down = iCommandViewSwitchReverse, name = 'Objects switching direction reverse ', category = 'View Extended'},
{combos = {{key = 'Delete', reformers = {'LAlt'}}}, 		down = iCommandViewObjectIgnore, name = 'Object exclude ', category = 'View Extended'},
{combos = {{key = 'Insert', reformers = {'LAlt'}}}, 		down = iCommandViewObjectsAll, name = 'Objects all excluded - include', category = 'View Extended'},

-- Padlock

{down = iCommandViewLock, name = 'Lock view (cycle padlock)', category = 'View Padlock'},
{combos = {{key = 'Num.', reformers = {'RShift'}}}, down = iCommandAllMissilePadlock, name = 'All missiles padlock', category = 'View Padlock'},
{combos = {{key = 'Num.', reformers = {'RAlt'}}}, down = iCommandThreatMissilePadlock, name = 'Threat missile padlock', category = 'View Padlock'},
{combos = {{key = 'NumLock'}}, 			down = iCommandViewUnlock, name = 'Unlock view (stop padlock)', category = 'View Padlock'},
{combos = {{key = 'Num.', reformers = {'RCtrl'}}}, 	down = iCommandViewTerrainLock, name = 'Lock terrain view', category = 'View Padlock'},
{combos = {{key = 'Num.'}}, down = iCommandPlaneQuickPadlockOn, up = iCommandPlaneQuickPadlockOff, name = 'Quick Padlock', category = 'View Padlock'},


-- Labels
{combos = {{key = 'F10', reformers = {'LShift'}}}, 	down = iCommandMarkerState, name = 'All Labels', category = 'Labels'},
{combos = {{key = 'F2', reformers = {'LShift'}}}, 	down = iCommandMarkerStatePlane, name = 'Aircraft Labels', category = 'Labels'},
{combos = {{key = 'F6', reformers = {'LShift'}}}, 	down = iCommandMarkerStateRocket, name = 'Missile Labels', category = 'Labels'},
{combos = {{key = 'F9', reformers = {'LShift'}}}, 	down = iCommandMarkerStateShip, name = 'Vehicle & Ship Labels', category = 'Labels'},

-- HOTAS
{combos = {{key = 'Space', reformers = {'RAlt'}}}, 	down = iCommandPlanePickleOn, up = iCommandPlanePickleOff, name = 'Weapon release', category = 'HOTAS'},
{combos = {{key = 'Space'}}, 	down = iCommandPlane_HOTAS_TriggerSecondStage, up = iCommandPlane_HOTAS_TriggerSecondStage_Off, name = 'Gun Trigger', category = 'HOTAS'},
{down = iCommandPlane_HOTAS_TriggerFirstStage , up = iCommandPlane_HOTAS_TriggerFirstStage_Off, name = 'Gun Trigger (first stage)', category = 'HOTAS'},

{combos = {{key = 'Home'}}, 	down = iCommandPlane_HOTAS_DataManagementSwitchUp,    up = iCommandPlane_HOTAS_DataManagementSwitchOff, name = 'HOTAS DMS Forward',    category = 'HOTAS'},
{combos = {{key = 'End'}}, 		down = iCommandPlane_HOTAS_DataManagementSwitchDown,  up = iCommandPlane_HOTAS_DataManagementSwitchOff, name = 'HOTAS DMS Aft',  category = 'HOTAS'},
{down = iCommandPlane_HOTAS_DataManagementSwitchLeft,  up = iCommandPlane_HOTAS_DataManagementSwitchOff, name = 'HOTAS DMS Left',  category = 'HOTAS'},
{combos = {{key = 'PageDown'}}, down = iCommandPlane_HOTAS_DataManagementSwitchRight, up = iCommandPlane_HOTAS_DataManagementSwitchOff, name = 'HOTAS DMS Right', category = 'HOTAS'},

{combos = {{key = 'Up',		reformers = {'LCtrl'}}}, 	down = iCommandPlane_HOTAS_TargetManagementSwitchUp,    up = iCommandPlane_HOTAS_TargetManagementSwitchOff, name = 'HOTAS TMS Forward',    category = 'HOTAS'},
{combos = {{key = 'Down',	reformers = {'LCtrl'}}}, 	down = iCommandPlane_HOTAS_TargetManagementSwitchDown,  up = iCommandPlane_HOTAS_TargetManagementSwitchOff, name = 'HOTAS TMS Aft',  category = 'HOTAS'},
{combos = {{key = 'Left',	reformers = {'LCtrl'}}}, 	down = iCommandPlane_HOTAS_TargetManagementSwitchLeft,  up = iCommandPlane_HOTAS_TargetManagementSwitchOff, name = 'HOTAS TMS Left',  category = 'HOTAS'},
{combos = {{key = 'Right',	reformers = {'LCtrl'}}}, 	down = iCommandPlane_HOTAS_TargetManagementSwitchRight, up = iCommandPlane_HOTAS_TargetManagementSwitchOff, name = 'HOTAS TMS Right', category = 'HOTAS'},

{combos = {{key = '7'}}, 		down = iCommandPlane_HOTAS_CMS_Up   , up = iCommandPlane_HOTAS_CMS_Off, name = 'HOTAS CMS Forward', category = 'HOTAS'},
{combos = {{key = '8'}}, 		down = iCommandPlane_HOTAS_CMS_Down , up = iCommandPlane_HOTAS_CMS_Off, name = 'HOTAS CMS Aft',  category = 'HOTAS'},
{combos = {{key = '9'}}, 		down = iCommandPlane_HOTAS_CMS_Left , up = iCommandPlane_HOTAS_CMS_Off, name = 'HOTAS CMS Left',  category = 'HOTAS'},
{combos = {{key = '0'}}, 		down = iCommandPlane_HOTAS_CMS_Right, up = iCommandPlane_HOTAS_CMS_Off, name = 'HOTAS CMS Right', category = 'HOTAS'},
{combos = {{key = '-'}}, 		down = iCommandPlane_HOTAS_CMS_Zaxis, up = iCommandPlane_HOTAS_CMS_Zaxis_Off, name = 'HOTAS CMS Z Axis', category = 'HOTAS'},

{combos = {{key = ';'}}, 		pressed = iCommandPlaneRadarUp, up = iCommandPlaneRadarStop, name = 'HOTAS Slew Up', category = 'HOTAS'},
{combos = {{key = '.'}}, 		pressed = iCommandPlaneRadarDown, up = iCommandPlaneRadarStop, name = 'HOTAS Slew Down', category = 'HOTAS'},
{combos = {{key = ','}}, 		pressed = iCommandPlaneRadarLeft, up = iCommandPlaneRadarStop, name = 'HOTAS Slew Left', category = 'HOTAS'},
{combos = {{key = '/'}}, 		pressed = iCommandPlaneRadarRight, up = iCommandPlaneRadarStop, name = 'HOTAS Slew Right', category = 'HOTAS'},

{combos = {{key = 'U'}}, 		down = iCommandPlane_HOTAS_CoolieUp,    up = iCommandPlane_HOTAS_CoolieOff, name = 'HOTAS Coolie Switch Up',    category = 'HOTAS'},
{combos = {{key = 'J'}}, 		down = iCommandPlane_HOTAS_CoolieDown,  up = iCommandPlane_HOTAS_CoolieOff, name = 'HOTAS Coolie Switch Down',  category = 'HOTAS'},
{combos = {{key = 'H'}}, 		down = iCommandPlane_HOTAS_CoolieLeft,  up = iCommandPlane_HOTAS_CoolieOff, name = 'HOTAS Coolie Switch Left',  category = 'HOTAS'},
{combos = {{key = 'K'}}, 		down = iCommandPlane_HOTAS_CoolieRight, up = iCommandPlane_HOTAS_CoolieOff, name = 'HOTAS Coolie Switch Right', category = 'HOTAS'},

{combos = {{key = 'Left',	reformers = {'RAlt'}}},	down = iCommandPlane_HOTAS_BoatSwitchAft, name = 'HOTAS Boat Switch Aft', category = 'HOTAS'},
{combos = {{key = 'Down',	reformers = {'RAlt'}}},	down = iCommandPlane_HOTAS_BoatSwitchCenter, name = 'HOTAS Boat Switch Center', category = 'HOTAS'},
{combos = {{key = 'Right',	reformers = {'RAlt'}}},	down = iCommandPlane_HOTAS_BoatSwitchForward, name = 'HOTAS Boat Switch Forward', category = 'HOTAS'},

{combos = {{key = 'C'}}, 		down = iCommandPlane_HOTAS_ChinaHatAft, up = iCommandPlane_HOTAS_ChinaHatOff, name = 'HOTAS China Hat Aft', category = 'HOTAS'},
{down = iCommandPlane_HOTAS_ChinaHatForward, up = iCommandPlane_HOTAS_ChinaHatOff, name = 'HOTAS China Hat Forward', category = 'HOTAS'},

{combos = {{key = 'Q'}}, 		down = iCommandPlane_HOTAS_LeftThrottleButton, name = 'HOTAS Left Throttle Button', category = 'HOTAS'},
{down = iCommandPlane_HOTAS_MasterModeControlButton, up = iCommandPlane_HOTAS_MasterModeControlButtonUP, name = 'HOTAS Master Mode Control Button', category = 'HOTAS'},
{combos = {{key = 'Insert'}}, 	down = iCommandPlane_HOTAS_NoseWheelSteeringButton, up = iCommandPlane_HOTAS_NoseWheelSteeringButtonOff, name = 'HOTAS Nosewheel Steering Button', category = 'HOTAS'},

{combos = {{key = 'B', reformers = {'LCtrl'}}}, 	down = iCommandPlane_HOTAS_SpeedBrakeSwitchAft, up = iCommandPlane_HOTAS_SpeedBrakeSwitchCenter, name = 'HOTAS Speed Brake Switch Aft', category = 'HOTAS'},
{combos = {{key = 'B', reformers = {'LShift'}}}, 	down = iCommandPlane_HOTAS_SpeedBrakeSwitchForward, up = iCommandPlane_HOTAS_SpeedBrakeSwitchCenter, name = 'HOTAS Speed Brake Switch Forward', category = 'HOTAS'},

{combos = {{key = 'P', reformers = {'LCtrl'}}}, 	down = iCommandPlane_HOTAS_PinkySwitchAft,     name = 'HOTAS Pinky Switch Aft',     category = 'HOTAS'},
{combos = {{key = 'P', reformers = {'LAlt'}}}, 		down = iCommandPlane_HOTAS_PinkySwitchForward, name = 'HOTAS Pinky Switch Forward', category = 'HOTAS'},
{combos = {{key = 'P', reformers = {'LShift'}}}, 	down = iCommandPlane_HOTAS_PinkySwitchCenter,  name = 'HOTAS Pinky Switch Center',  category = 'HOTAS'},

{combos = {{key = 'Num+', reformers = {'LShift'}}}, down = iCommandPlane_HOTAS_MIC_SwitchUp,    up = iCommandPlane_HOTAS_MIC_SwitchOff, name = 'HOTAS MIC Switch Up',    category = 'HOTAS'},
{combos = {{key = 'Num-', reformers = {'LAlt'}}}, 	down = iCommandPlane_HOTAS_MIC_SwitchDown,  up = iCommandPlane_HOTAS_MIC_SwitchOff, name = 'HOTAS MIC Switch Down',  category = 'HOTAS'},
{combos = {{key = 'Num-', reformers = {'LShift'}}}, down = iCommandPlane_HOTAS_MIC_SwitchLeft,  up = iCommandPlane_HOTAS_MIC_SwitchOff, name = 'HOTAS MIC Switch Aft',  category = 'HOTAS'},
{combos = {{key = 'Num+', reformers = {'LAlt'}}}, 	down = iCommandPlane_HOTAS_MIC_SwitchRight, up = iCommandPlane_HOTAS_MIC_SwitchOff, name = 'HOTAS MIC Switch Forward', category = 'HOTAS'},

{combos = {{key = ';', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimUp, up = iCommandPlaneTrimStop, name = 'Trim: Nose Down', category = 'HOTAS'},
{combos = {{key = '.', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimDown, up = iCommandPlaneTrimStop, name = 'Trim: Nose Up', category = 'HOTAS'},
{combos = {{key = ',', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimLeft, up = iCommandPlaneTrimStop, name = 'Trim: Left Wing Down', category = 'HOTAS'},
{combos = {{key = '/', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimRight, up = iCommandPlaneTrimStop, name = 'Trim: Right Wing Down', category = 'HOTAS'},
{combos = {{key = 'E', reformers = {'LAlt'}}} , pressed = iCommandPlaneEmergencyDisconnectLever, name = 'Emergency Disconnect Lever', category = 'HOTAS'},

-- Flight Control
{down = iCommandPlaneTrimOn, up = iCommandPlaneTrimOff, name = 'Stick to trimmer control mode', category = 'Flight Control'},
{combos = {{key = 'Z', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimLeftRudder ,name = 'Trim Left Rudder', category = 'Flight Control'},
{combos = {{key = 'X', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimRightRudder,name = 'Trim Right Rudder', category = 'Flight Control'},

{combos = {{key = 'Up'}},						down = iCommandPlaneUpStart, up = iCommandPlaneUpStop, name = 'Fly (pitch down)', category = 'Flight Control'},
{combos = {{key = 'Down'}},						down = iCommandPlaneDownStart, up = iCommandPlaneDownStop, name = 'Fly (pitch up)', category = 'Flight Control'},
{combos = {{key = 'Left'}},						down = iCommandPlaneLeftStart, up = iCommandPlaneLeftStop, name = 'Fly (roll left)', category = 'Flight Control'},
{combos = {{key = 'Right'}},					down = iCommandPlaneRightStart, up = iCommandPlaneRightStop, name = 'Fly (roll right)', category = 'Flight Control'},
{combos = {{key = 'Z'}},						down = iCommandPlaneLeftRudderStart, up = iCommandPlaneLeftRudderStop, name = 'Rudder left', category = 'Flight Control'},
{combos = {{key = 'X'}},						down = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, name = 'Rudder right', category = 'Flight Control'},
{combos = {{key = 'T', reformers = {'LCtrl'}}}, down = iCommandPlaneTrimCancel, name = 'Reset Trimmers', category = 'Flight Control'},

{combos = {{key = 'Num+'}},								  down = iCommandThrottleIncrease,	up = iCommandThrottleStop,	name = 'Throttle Common Up', category = 'Flight Control'},
{combos = {{key = 'Num-'}},								  down = iCommandThrottleDecrease,	up = iCommandThrottleStop,	name = 'Throttle Common Down', category = 'Flight Control'},
{combos = {{key = 'Num+'	, reformers = {'RAlt'}}}	, down = iCommandThrottle1Increase,	up = iCommandThrottle1Stop,	name = 'Throttle Left Up', category = 'Flight Control'},
{combos = {{key = 'Num-'	, reformers = {'RAlt'}}}	, down = iCommandThrottle1Decrease,	up = iCommandThrottle1Stop,	name = 'Throttle Left Down', category = 'Flight Control'},
{combos = {{key = 'Num+'	, reformers = {'RCtrl'}}}	, down = iCommandThrottle2Increase,	up = iCommandThrottle2Stop,	name = 'Throttle Right Up', category = 'Flight Control'},
{combos = {{key = 'Num-'	, reformers = {'RCtrl'}}}	, down = iCommandThrottle2Decrease,	up = iCommandThrottle2Stop,	name = 'Throttle Right Down', category = 'Flight Control'},
{combos = {{key = 'PageUp'  , reformers = {'RAlt'}}}	, down = iCommandPlaneAUTIncreaseRegimeLeft,					name = 'Throttle Left Up Step', category = 'Flight Control'},
{combos = {{key = 'PageDown', reformers = {'RAlt'}}}	, down = iCommandPlaneAUTDecreaseRegimeLeft,					name = 'Throttle Left Down Step', category = 'Flight Control'},
{combos = {{key = 'PageUp'  , reformers = {'RCtrl'}}}	, down = iCommandPlaneAUTIncreaseRegimeRight,					name = 'Throttle Right Up Step', category = 'Flight Control'},
{combos = {{key = 'PageDown', reformers = {'RCtrl'}}}	, down = iCommandPlaneAUTDecreaseRegimeRight,					name = 'Throttle Right Down Step', category = 'Flight Control'},

{down    = iCommandPlaneAUTIncreaseRegime	, name = 'Thrust Up', category = 'Flight Control'},
{down    = iCommandPlaneAUTDecreaseRegime	, name = 'Thrust Down', category = 'Flight Control'},
{pressed = iCommandPlaneAUTIncreaseLeft		, name = 'Power Up Left', category = 'Flight Control'},
{pressed = iCommandPlaneAUTDecreaseLeft		, name = 'Power Down Left', category = 'Flight Control'},
{pressed = iCommandPlaneAUTIncreaseRight	, name = 'Power Up Right', category = 'Flight Control'},
{pressed = iCommandPlaneAUTDecreaseRight	, name = 'Power Down Right', category = 'Flight Control'},
{down    = iCommandPlaneAUTIncreaseRegimeLeft	, name = 'Thrust Up Left', category = 'Flight Control'},
{down    = iCommandPlaneAUTDecreaseRegimeLeft	, name = 'Thrust Down Left', category = 'Flight Control'},
{down    = iCommandPlaneAUTIncreaseRegimeRight	, name = 'Thrust Up Right', category = 'Flight Control'},
{down    = iCommandPlaneAUTDecreaseRegimeRight	, name = 'Thrust Down Right', category = 'Flight Control'},


-- Systems
{combos = {{key = 'G'}},						 		 down = iCommandPlaneGear, name = 'Toggle Landing Gear Up/Down', category = 'Systems'},
{combos = {{key = 'G', reformers = {'LCtrl'}}} , 		 down = iCommandPlaneGearUp, name = 'Toggle Landing Gear Up', category = 'Systems'},
{combos = {{key = 'G', reformers = {'LShift'}}}, down = iCommandPlaneGearDown, name = 'Toggle Landing Gear Down', category = 'Systems'},
{combos = {{key = 'G', reformers = {'LAlt'}}}  , 		 down = iCommandPlaneHook, name = 'Toggle Arrestor Hook', category = 'Systems'},
{combos = {{key = 'G', reformers = {'RAlt'}}}, 			 down = iCommandEmergencyGear, name = 'Emeregency gear', category = 'Systems'},


{combos = {{key = 'F'}},					 		down = iCommandPlaneFlaps   , name = 'Toggle Flaps Up/Down', category = 'Systems'},
{combos = {{key = 'F', reformers = {'LShift'}}}, 	down = iCommandPlaneFlapsOn , name = 'Flaps Down To The Landing Position', category = 'Systems'},
{combos = {{key = 'F', reformers = {'LCtrl'}}} , 	down = iCommandPlaneFlapsOff, name = 'Flaps Up', category = 'Systems'},
{combos = {{key = 'W'}}, 							down = iCommandPlaneWheelBrakeOn, up = iCommandPlaneWheelBrakeOff, name = 'Wheel Brake On/Off', category = 'Systems'},
{combos = {{key = 'W', reformers = {'LShift'}}}, 	down = iCommandPlaneWheelBrakeLeftOn, up = iCommandPlaneWheelBrakeLeftOff, name = 'Wheel Brake Left On/Off', category = 'Systems'},
{combos = {{key = 'W', reformers = {'LAlt'}}}, 		down = iCommandPlaneWheelBrakeRightOn, up = iCommandPlaneWheelBrakeRightOff, name = 'Wheel Brake Right On/Off', category = 'Systems'},
{combos = {{key = 'W', reformers = {'RWin'}}}, 		down = iCommandPlaneEmergencyBrake, name = 'Emergency Wheel Brake', category = 'Systems'},

{combos = {{key = 'Home', reformers = {'RAlt'}}} , 	down = iCommandLeftEngineStart, name = 'Left Engine Start', category = 'Systems'},
{combos = {{key = 'Home', reformers = {'RCtrl'}}}, 	down = iCommandRightEngineStart, name = 'Right Engine Start', category = 'Systems'},
{combos = {{key = 'End', reformers = {'RAlt'}}} , 	down = iCommandLeftEngineStop, name = 'Left Engine Stop', category = 'Systems'},
{combos = {{key = 'End', reformers = {'RCtrl'}}}, 	down = iCommandRightEngineStop, name = 'Right Engine Stop', category = 'Systems'},
{combos = {{key = 'R', reformers = {'LAlt'}}} , 	down = iCommandPlaneJettisonFuelTanks				 , name = 'Jettison Fuel Tanks', category = 'Systems'},
{combos = {{key = 'C', reformers = {'LCtrl'}}}, 	down = iCommandPlaneFonar, name = 'Canopy Open/Close', category = 'Systems'},
{combos = {{key = 'E', reformers = {'LCtrl'}}}, 	down = iCommandPlaneEject, name = 'Eject', category = 'Systems'},
{combos = {{key = 'L'}}, 							down = iCommandPlaneCockpitIllumination, name = 'Cockpit Illumination', category = 'Systems'},
{combos = {{key = 'L', reformers = {'RAlt'}}}, 		down = iCommandPlaneHeadLightOnOff, name = 'Toggle Gear Light Near/Far/Off', category = 'Systems'},
{combos = {{key = 'L', reformers = {'RCtrl'}}}, 	down = iCommandPlaneLightsOnOff, name = 'Toggle Navigation lights', category = 'Systems'},
{combos = {{key = 'T', reformers = {'LShift'}}}, 	down = iCommandPlaneWingtipSmokeOnOff, name = 'Toggle Smoke', category = 'Systems'},
{combos = {{key = 'N', reformers = {'RShift'}}}, 	down = iCommandPlaneResetMasterWarning, name = 'Reset Current Audible Warning', category = 'Systems'},
{combos = {{key = 'W', reformers = {'LCtrl'}}}, 	down = iCommandPlaneJettisonWeapons, name = 'Jettison Weapons', category = 'Systems'},
{combos = {{key = 'C', reformers = {'RWin'}}}, 		down = iCommandFlightClockReset, name = 'Start/Stop/Reset Flight Clock', category = 'Systems'},
{combos = {{key = 'H', reformers = {'RCtrl'}}}, 	down = iCommandBrightnessILS, name = 'HUD Color', category = 'Systems'},


-- Autopilot
{combos = {{key = '1'}},down = iCommandPlaneAutopilot, up = iCommandPlaneAutopilot, name 		= 'LAAP Engage/Disengage'     , category = 'LASTE Control Panel'},
{combos = {{key = '2'}},down = iCommandPlaneStabPathHold	, name 	= 'LAAP Path Hold'			  , category = 'LASTE Control Panel'},
{combos = {{key = '3'}},down = iCommandPlaneStabHbarHeading	, name  = 'LAAP Altitude/Heading Hold', category = 'LASTE Control Panel'},
{combos = {{key = '4'}},down = iCommandPlaneStabHbarBank	, name 	= 'LAAP Altitude/Bank Hold'   , category = 'LASTE Control Panel'},
{down = iCommandPlane_EAC_ARM, name 		= 'EAC Arm'					  , category = 'LASTE Control Panel'},
{down = iCommandPlane_EAC_OFF, name 		= 'EAC Off'					  , category = 'LASTE Control Panel'},
{down = iCommandPlane_RDR_ALTM_NRM, name 	= 'RDR ALTM Normal'			  , category = 'LASTE Control Panel'},
{down = iCommandPlane_RDR_ALTM_DIS, name 	= 'RDR ALTM Disable'	      , category = 'LASTE Control Panel'},

-- Engine Control Panel

{down = iCommandPlane_LG_WRN_Silence		, up = iCommandPlane_LG_WRN_Silence		, name = 'Landing Gear Warning Silence'			, category = 'Engine Control Panel'};
{down = iCommandPlane_APU_Start														, name = 'APU Start'							, category = 'Engine Control Panel'};
{down = iCommandPlane_APU_Off														, name = 'APU Off'								, category = 'Engine Control Panel'};
{down = iCommandPlane_L_ENG_OPER_Ign 		, up = iCommandPlane_L_ENG_OPER_Norm	, name = 'Left Engine Oper Ign / Norm'			, category = 'Engine Control Panel'};
{down = iCommandPlane_L_ENG_OPER_Motor												, name = 'Left Engine Oper Motor'				, category = 'Engine Control Panel'};
{down = iCommandPlane_L_ENG_OPER_Norm												, name = 'Left Engine Oper Norm'				, category = 'Engine Control Panel'};
{down = iCommandPlane_R_ENG_OPER_Ign 		, up = iCommandPlane_R_ENG_OPER_Norm	, name = 'Right Engine Oper Ign / Norm'			, category = 'Engine Control Panel'};
{down = iCommandPlane_R_ENG_OPER_Motor												, name = 'Right Engine Oper Motor'				, category = 'Engine Control Panel'};
{down = iCommandPlane_R_ENG_OPER_Norm												, name = 'Right Engine Oper Norm'				, category = 'Engine Control Panel'};
{down = iCommandPlane_L_ENG_FUEL_FLOW_Norm											, name = 'Left Engine Fuel Flow Norm/Override'	, category = 'Engine Control Panel'};
{down = iCommandPlane_L_ENG_FUEL_FLOW_Override										, name = 'Left Engine Fuel Flow Norm/Override'	, category = 'Engine Control Panel'};
{down = iCommandPlane_R_ENG_FUEL_FLOW_Norm											, name = 'Right Engine Fuel Flow Norm/Override'	, category = 'Engine Control Panel'};
{down = iCommandPlane_R_ENG_FUEL_FLOW_Override										, name = 'Right Engine Fuel Flow Norm/Override'	, category = 'Engine Control Panel'};



-- {combos = {{key = 'L', reformers = {'LShift'}}}, down = iCommandLampsControl, up = iCommandLampsControl_up, name = 'Lamps test', category = 'Temporal'},

--NightVision
{combos = {{key = 'H', reformers = {'RShift'}}}		   , down    = iCommandViewNightVisionGogglesOn   , name = 'Toggle goggles'   , category = 'Sensors'},
{combos = {{key = 'H', reformers = {'RShift','RCtrl'}}}, pressed = iCommandPlane_Helmet_Brightess_Up  , name = 'Gain goggles up'  , category = 'Sensors'},
{combos = {{key = 'H', reformers = {'RShift','RAlt'}}} , pressed = iCommandPlane_Helmet_Brightess_Down, name = 'Gain goggles down', category = 'Sensors'},

--FAC
--{combos = {{key = 'B', reformers = {'LWin'}}}, down = iCommandViewBinocular , name = 'Binocular view toggle', category = 'FAC'},
--{combos = {{key = 'L', reformers = {'LAlt'}}}, down = iCommandViewLaserOnOff, name = 'Binocular laser illumination toggle', category = 'FAC'},
--{combos = {{key = 'Z', reformers = {'LWin'}}}, down = iCommandViewIR		, name = 'Binocular view IR mode', category = 'FAC'},


-- Auto Lock On
{combos = {{key = 'O'}}, down = iCommandAutoLockOnNearestAircraft, name = 'Auto lock on nearest aircraft', category = 'Targeting'},
{combos = {{key = 'P'}}, down = iCommandAutoLockOnCenterAircraft, name = 'Auto lock on center aircraft', category = 'Targeting'},
{combos = {{key = ']'}}, down = iCommandAutoLockOnNextAircraft, name = 'Auto lock on next aircraft', category = 'Targeting'},
{combos = {{key = '['}}, down = iCommandAutoLockOnPreviousAircraft, name = 'Auto lock on previous aircraft', category = 'Targeting'},
{combos = {{key = 'B'}}, down = iCommandAutoLockOnNearestSurfaceTarget, name = 'Auto lock on nearest surface target', category = 'Targeting'},
{combos = {{key = 'V'}}, down = iCommandAutoLockOnCenterSurfaceTarget, name = 'Auto lock on center surface target', category = 'Targeting'},
{combos = {{key = 'M'}}, down = iCommandAutoLockOnNextSurfaceTarget, name = 'Auto lock on next surface target', category = 'Targeting'},
{combos = {{key = 'N'}}, down = iCommandAutoLockOnPreviousSurfaceTarget, name = 'Auto lock on previous surface target', category = 'Targeting'},
{combos = {{key = 'Delete'}}, down = iCommandAutoLockOnClear, name = 'Clear Selected Target', category = 'Targeting'},

{combos = {{key = '='}},  down = iCommandEasyRadarScaleUp , name = 'Easy Radar scale in' , category = 'Targeting'},
{combos = {{key = '-'}},  down = iCommandEasyRadarScaleOut, name = 'Easy Radar scale out', category = 'Targeting'},
{combos = {{key = 'D'}} , down = iCommandPlaneChangeWeapon, name = 'Change Weapon', category = 'Weapons'},
{combos = {{key = 'Home', reformers = {'LWin'}}}, down = iCommandEnginesStart, name = 'Start Engines', category = 'Systems'},
{combos = {{key = 'End' , reformers = {'LWin'}}} , down = iCommandEnginesStop, name = 'Stop Engines' , category = 'Systems'},

{combos = {{key = ';' , reformers = {'RShift'}}}, pressed = iCommandSelecterUp   , up = iCommandSelecterStop, name = 'Selector up'   , category = 'Targeting'},
{combos = {{key = '.' , reformers = {'RShift'}}}, pressed = iCommandSelecterDown , up = iCommandSelecterStop, name = 'Selector down' , category = 'Targeting'},
{combos = {{key = ',' , reformers = {'RShift'}}}, pressed = iCommandSelecterLeft , up = iCommandSelecterStop, name = 'Selector left' , category = 'Targeting'},
{combos = {{key = '/' , reformers = {'RShift'}}}, pressed = iCommandSelecterRight, up = iCommandSelecterStop, name = 'Selector right', category = 'Targeting'},

{down = iCommandEasyRadarOnOff, name = 'Easy Radar toggle', category = 'Targeting'},


},
}
end
